<!--{"language":"warnings","icon":"fa-exclamation-triangle","position":60}-->
<?php 
	if(!isset($G_MAIN) && !isset($G_REQUEST)){
		die(json_encode(array("error" => "authentification failed")));
	}
?>
<?php
    if(!DemoLock()){
        if(isset($_POST['settings_warnings_submit'])){
            $checkboxes = array('settings_warnings_kick', 'settings_warnings_ban');
        	
        	foreach($checkboxes as $checkbox){
        		if(!array_key_exists($checkbox, $_POST)){
        			$_POST[$checkbox] = 0;
        		}else{
        			$_POST[$checkbox] = 1;
        		}
        	}
        	
            foreach($_POST as $key => $postvar){
                if($key != 'settings_warnings_submit' && StartsWith($key, 'settings_warnings_')){
                    Settings::Set($key, $postvar);
                }
            }
            DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('changes_saved').'", type: "success"');
        }
    }
?>

<h3><?php echo Lang('warnings'); ?></h3>

<hr>

<div class="row">
    <div class="col-xs-12">
        <form method="post" action="index.php?t=admin_settings&part=warnings">
           <div class="row">
                <div class="col-xs-6">
                    <label><?php echo Lang('kick_on_threshold'); ?></label>
			    	<?php CreateCheckBox('primary', 'settings_warnings_kick', '', Lang('kick_enable')); ?>
			    </div>

				<div class="col-xs-6">
					<label><?php echo Lang('kick_threshold'); ?></label>
					<input name="settings_warnings_kick_threshold" class="form-control" value="2" />
				</div>
			</div>

			<br>

			<div class="row">
				<div class="col-xs-6">
					<label><?php echo Lang('ban_on_threshold'); ?></label>
		        	<?php CreateCheckBox('primary', 'settings_warnings_ban', '', Lang('ban_enable')); ?>
				</div>

				<div class="col-xs-6">
					<label><?php echo Lang('ban_threshold'); ?></label>
					<input name="settings_warnings_ban_threshold" class="form-control" value="4" />
				</div>
			</div>

			<br>

			<div class="row">
				<div class="col-xs-6">
					<label><?php echo Lang('length_ban'); ?></label>
					<input name="settings_warnings_ban_length" class="form-control" value="180" />
				</div>

				<div class="col-xs-6">
					<label><?php echo Lang('time_decay'); ?></label>
					<input name="settings_warnings_decay" class="form-control" value="1440" />
				</div>
			</div>
            
            <br />
            
            <!-- Submit Button -->
            <button name="settings_warnings_submit" type="submit" class="btn btn-primary"><?php echo Lang('save'); ?></button>
        </form>
        
    </div>
</div>

<script>
	$('input[name="settings_warnings_kick_threshold"], input[name="settings_warnings_ban_threshold"]').TouchSpin({
        min: 0,
        max: 100,
    	step: 1,
    	forcestepdivisibility: 'none',
        decimals: 0,
        verticalbuttons: true
    });

    $('input[name="settings_warnings_ban_length"], input[name="settings_warnings_decay"]').TouchSpin({
        min: 0,
        max: 1000000,
    	step: 60,
    	forcestepdivisibility: 'none',
        decimals: 0,
        verticalbuttons: true,
        postfix: '<?php echo Lang('minutes'); ?>'
    });
    
    $('input[name="settings_warnings_kick"]').prop('checked', <?php echo OneLine(Settings::Get('settings_warnings_kick')); ?>);
    $('input[name="settings_warnings_ban"]').prop('checked', <?php echo OneLine(Settings::Get('settings_warnings_ban')); ?>);
    $('input[name="settings_warnings_kick_threshold"]').val('<?php echo OneLine(Settings::Get('settings_warnings_kick_threshold')); ?>');
    $('input[name="settings_warnings_ban_threshold"]').val('<?php echo OneLine(Settings::Get('settings_warnings_ban_threshold')); ?>');
    $('input[name="settings_warnings_ban_length"]').val('<?php echo OneLine(Settings::Get('settings_warnings_ban_length')); ?>');
    $('input[name="settings_warnings_decay"]').val('<?php echo OneLine(Settings::Get('settings_warnings_decay')); ?>');
</script>